/*****************************************************************
;*        Sample SFR/Vector File for TLCS-870/C1 Series          *
;*               Memory Style: Within 64K byte                   *
;*---------------------------------------------------------------*
;*  (C)Copyright iMQ CORPORATION 2010  All rights reserved       *
;*****************************************************************/
//#define IO_MEM    1


#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

void startup(void);	//defined by startup.asm
/*========================================================
  [ Declare interrupt function ]
  ========================================================*/
void __interrupt Int2(void); 
void __interrupt Int3(void); 
void __interrupt IntTC00(void); 
void __interrupt IntTC01(void);
void __interrupt IntTC02(void);
void __interrupt IntTC03(void);
void __interrupt IntTC04(void);
void __interrupt IntTC05(void);
void __interrupt IntTCA0(void);
void __interrupt IntRTC(void);
void __interrupt IntADC(void);
void __interrupt IntVLTD(void);
void __interrupt IntRXD1(void);
void __interrupt IntTXD1(void);
void __interrupt IntSIO0(void);
void __interrupt IntTBT(void);
void __interrupt IntWUC(void);
void __interrupt_n IntWDT(void);  
void __interrupt_n IntSWI(void);  


/*========================================================
  [ Dummy function for interrupt ]
  ========================================================*/
void __interrupt		Int_dummy(void){ }
void __interrupt_n		Int_n_dummy(void){ }

/*========================================================
  [ Implement interrupt function]
  ========================================================*/
void __interrupt Int2(void)
{
	//Add your interrupt handler code here
}    
void __interrupt Int3(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTC00(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTC01(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTC02(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTC03(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTC04(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTC05(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTCA0(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntRTC(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntADC(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntVLTD(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntRXD1(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntTXD1(void)
{
	//Add your interrupt handler code here
}      
void __interrupt IntSIO0(void)
{
	//Add your interrupt handler code here
}    
void __interrupt IntTBT(void)
{
	//Add your interrupt handler code here
}   
void __interrupt IntWUC(void)
{
	//Add your interrupt handler code here
}   
void __interrupt_n IntWDT(void)
{
	//Add your interrupt handler code here
}    
void __interrupt_n IntSWI(void)
{
    unsigned char *p_coming_opcode = ((*(unsigned short *)(__SP + (6 * 2) + 1)) - 1);
    unsigned char r_index;
    static const unsigned char a_invalid_opcode[] = {  /* invalid opcode */
            0x01,0x02,0x03,0x68,0x69,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0xf8,0xff };		

    for( r_index = 0; r_index < ( sizeof(a_invalid_opcode)/sizeof(a_invalid_opcode[0])); r_index++ )
    {
        if ( *p_coming_opcode == a_invalid_opcode[r_index] )
            SYSCR2.byte=0x10;	//system clock reset
    }

    // adjust address for return from IntSWI // '
    (*(unsigned short *)(__SP + (6 * 2) + 1))--;
		
    // cost 6 bytes for fix stack //
    __asm("dec	wa");
    __asm("dec	bc");
    __asm("dec	de");
    __asm("dec	hl");
    __asm("dec	ix");
    __asm("dec	iy");	
}        
/*============================================
  [ Define interrupt table ]
    This part must be rewrite.
  ============================================*/
#pragma section const INT_VECTOR1
void * const IntTbl1[] = {
	IntTC05,			/* 0xffc4 : IntTC05 */
    IntTC04,			/* 0xffc6 : IntTC04 */
	(void *)0xffff,		/* 0xffc8 : Reserved */
    (void *)0xffff,		/* 0xffca : Reserved */
    IntTC03,			/* 0xffcc : IntTC03 */
    IntTC02,			/* 0xffce : IntTC02 */
    IntTXD1,			/* 0xffd0 : IntTXD1 */
    IntRXD1,			/* 0xffd2 : IntRXD1 */
    Int_dummy,			/* 0xffd4 : Reserved */	
    Int_dummy,				/* 0xffd6 : Int4 */
    Int3,				/* 0xffd8 : Int3 */
    Int2,				/* 0xffda : Int2 */
    Int_dummy,			/* 0xffdc : Reserved */
    Int_dummy,			/* 0xffde : Reserved */
    Int_dummy,				/* 0xffe0 : IntSBI */
    IntTCA0,			/* 0xffe2 : IntTCA0  */
    IntTC01,			/* 0xffe4 : IntTC01 */
    IntTC00,			/* 0xffe6 : IntTC00 */
    IntRTC,				/* 0xffe8 : IntRTC */
    IntADC,				/* 0xffea : IntADC */
    IntVLTD,			/* 0xffec : IntVLTD */
    Int_dummy,			/* 0xffee : Reserved */
    Int_dummy,			/* 0xfff0 : Reserved */
    IntSIO0,			/* 0xfff2 : IntSIO0 */
    IntTBT,				/* 0xfff4 : IntTBT */
    IntWUC,	    		/* 0xfff6 : IntWUC */
    IntWDT,				/* 0xfff8 : IntWDT */
    (void *)0xffff,		/* 0xfffa : Reserved */
    IntSWI,	   			/* 0xfffc : IntSWI/INTUNDEF */     
    startup		    	/* 0xfffe : RESET */					
};
#pragma section const   /* return to default */
